/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.header;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.codec.RestObjectMapperFactory;
import org.apache.servicecomb.common.rest.codec.header.HeaderCodec;
import org.apache.servicecomb.common.rest.codec.param.HeaderProcessorCreator;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public class HeaderCodecMulti
implements HeaderCodec {
    public static final String NAME = "multi";

    @Override
    public String getCodecName() {
        return NAME;
    }

    @Override
    public void encode(RestClientRequest clientRequest, String name, Object value) throws Exception {
        if (null == value) {
            return;
        }
        if (!(value instanceof Collection)) {
            throw new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, (Object)new CommonExceptionData("Array type of header should be Collection"));
        }
        for (Object item : (Collection)value) {
            clientRequest.getHeaders().add(name, RestObjectMapperFactory.getConsumerWriterMapper().convertToString(item));
        }
    }

    @Override
    public Object decode(HeaderProcessorCreator.HeaderProcessor processor, HttpServletRequest request) {
        Enumeration headerValues = request.getHeaders(processor.getParameterPath());
        if (headerValues == null) {
            return null;
        }
        return processor.convertValue(Collections.list(headerValues), processor.getTargetType());
    }
}

