/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.config;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.netflix.config.DynamicPropertyFactory;
import io.vertx.core.json.jackson.DatabindCodec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.foundation.common.utils.ClassLoaderScopeContext;
import org.apache.servicecomb.registry.api.registry.BasePath;

public final class ConfigurePropertyUtils {
    private ConfigurePropertyUtils() {
    }

    public static Map<String, String> getPropertiesWithPrefix(String prefix) {
        Object config = DynamicPropertyFactory.getBackingConfigurationSource();
        if (!Configuration.class.isInstance(config)) {
            return new HashMap<String, String>();
        }
        return ConfigurePropertyUtils.getPropertiesWithPrefix((Configuration)config, prefix);
    }

    public static Map<String, String> getPropertiesWithPrefix(Configuration configuration, String prefix) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        Iterator keysIterator = configuration.getKeys(prefix);
        while (keysIterator.hasNext()) {
            String key = (String)keysIterator.next();
            propertiesMap.put(key.substring(prefix.length() + 1), String.valueOf(configuration.getProperty(key)));
        }
        return propertiesMap;
    }

    public static List<BasePath> getMicroservicePaths(Configuration configuration) {
        List configPaths = BootStrapProperties.readServicePaths((Configuration)configuration);
        List basePaths = (List)DatabindCodec.mapper().convertValue((Object)configPaths, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, BasePath.class));
        for (BasePath basePath : basePaths) {
            basePath.setPath(ConfigurePropertyUtils.buildPath(basePath.getPath()));
        }
        return basePaths;
    }

    private static String buildPath(String path) {
        String prefix = ClassLoaderScopeContext.getClassLoaderScopeProperty((String)"urlPrefix");
        if (StringUtils.isNotEmpty((String)prefix) && !((String)path).startsWith(prefix)) {
            path = prefix + (String)path;
        }
        return path;
    }
}

