/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.lightweight.store;

import com.google.common.base.Ticker;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.registry.api.registry.FindInstancesResponse;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstanceStatus;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstances;
import org.apache.servicecomb.registry.lightweight.store.InstanceStore;

public class MicroserviceStore {
    private final Ticker ticker;
    private final Microservice microservice;
    private final Map<String, InstanceStore> instancesById = new ConcurrentHashMapEx();
    private String schemasSummary;
    private String instancesRevision;

    public MicroserviceStore(Ticker ticker, Microservice microservice, String schemasSummary) {
        this.ticker = ticker;
        this.microservice = microservice;
        this.schemasSummary = schemasSummary;
        this.updateInstancesRevision();
    }

    public void updateInstancesRevision() {
        this.instancesRevision = String.valueOf(this.ticker.read());
    }

    public String getServiceName() {
        return this.microservice.getServiceName();
    }

    public String getServiceId() {
        return this.microservice.getServiceId();
    }

    public Microservice getMicroservice() {
        return this.microservice;
    }

    public InstanceStore addInstance(MicroserviceInstance instance) {
        InstanceStore instanceStore = new InstanceStore(this.ticker, instance);
        this.instancesById.put(instance.getInstanceId(), instanceStore);
        this.updateInstancesRevision();
        return instanceStore;
    }

    public InstanceStore deleteInstance(String instanceId) {
        InstanceStore instanceStore = this.instancesById.remove(instanceId);
        if (instanceStore != null) {
            this.updateInstancesRevision();
        }
        return instanceStore;
    }

    public void updateInstanceStatus(InstanceStore instanceStore, MicroserviceInstanceStatus status) {
        instanceStore.setStatus(status);
        this.updateInstancesRevision();
    }

    public MicroserviceInstances findServiceInstances(String revision) {
        if (this.instancesRevision.equals(revision)) {
            return new MicroserviceInstances().setRevision(this.instancesRevision).setNeedRefresh(false);
        }
        List instances = this.instancesById.values().stream().map(InstanceStore::getInstance).collect(Collectors.toList());
        FindInstancesResponse response = new FindInstancesResponse().setInstances(instances);
        return new MicroserviceInstances().setRevision(this.instancesRevision).setInstancesResponse(response);
    }

    public boolean isSchemaChanged(String schemasSummary) {
        return !Objects.equals(this.schemasSummary, schemasSummary);
    }

    public MicroserviceStore setSchemasSummary(String schemasSummary) {
        this.schemasSummary = schemasSummary;
        return this;
    }

    public boolean hasInstance() {
        return !this.instancesById.isEmpty();
    }

    public int getInstanceCount() {
        return this.instancesById.size();
    }
}

