/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.sse;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SseEventResponseEntity<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SseEventResponseEntity.class);
    private Integer id;
    private String event;
    private Long retry;
    private List<T> datas = new ArrayList<T>();

    public SseEventResponseEntity<T> id(int id) {
        if (this.id != null) {
            LOGGER.warn("origin id: [{}] is exists, overridden by the current value: [{}]", (Object)this.id, (Object)id);
        }
        this.id = id;
        return this;
    }

    public SseEventResponseEntity<T> event(String event) {
        if (!StringUtils.isEmpty((CharSequence)this.event)) {
            LOGGER.warn("origin event: [{}] is exists, overridden by the current value: [{}]", (Object)this.event, (Object)event);
        }
        this.event = event;
        return this;
    }

    public SseEventResponseEntity<T> retry(long retry) {
        if (this.retry != null) {
            LOGGER.warn("origin retry: [{}] is exists, overridden by the current value: [{}]", (Object)this.retry, (Object)retry);
        }
        this.retry = retry;
        return this;
    }

    public SseEventResponseEntity<T> data(T data) {
        if (data == null) {
            LOGGER.warn("The data content cannot be null!");
        } else {
            this.datas.add(data);
        }
        return this;
    }

    public Integer getId() {
        return this.id;
    }

    public String getEvent() {
        return this.event;
    }

    public Long getRetry() {
        return this.retry;
    }

    public List<T> getData() {
        return this.datas;
    }

    @JsonIgnore
    @ApiModelProperty(hidden=true)
    public boolean isEmpty() {
        return this.id == null && this.event == null && this.retry == null && this.datas.isEmpty();
    }
}

