/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.edge.core;

import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.common.rest.filter.inner.RestServerCodecFilter;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.context.TransportContext;
import org.springframework.stereotype.Component;

@Component
public class EdgeServerCodecFilter
extends RestServerCodecFilter {
    public static final String NAME = "edge-server-codec";

    @Nonnull
    public String getName() {
        return NAME;
    }

    @Nonnull
    public List<InvocationType> getInvocationTypes() {
        return Collections.singletonList(InvocationType.CONSUMER);
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        if (invocation.getRequestEx() == null) {
            return nextNode.onFilter(invocation);
        }
        return super.onFilter(invocation, nextNode);
    }

    protected CompletableFuture<Response> invokeNext(Invocation invocation, FilterNode nextNode) {
        TransportContext transportContext = invocation.getTransportContext();
        return nextNode.onFilter(invocation).whenComplete((r, e) -> invocation.setTransportContext(transportContext));
    }
}

