/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.router.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.Subscribe;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.governance.event.GovernanceConfigurationChangedEvent;
import org.apache.servicecomb.governance.event.GovernanceEventManager;
import org.apache.servicecomb.router.model.PolicyRuleItem;
import org.apache.servicecomb.router.model.ServiceInfoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;

@Component
public class RouterRuleCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouterRuleCache.class);
    public static final String ROUTE_RULE_PREFIX = "servicecomb.routeRule.";
    private static final String ROUTE_RULE = "servicecomb.routeRule.%s";
    public static final String GLOBAL_ROUTE_RULE_KEY = "servicecomb.globalRouteRule";
    private final Environment environment;
    private final ConcurrentHashMap<String, ServiceInfoCache> serviceInfoCacheMap = new ConcurrentHashMap();
    private final Object lock = new Object();
    private final Representer representer = new Representer(new DumperOptions());

    @Autowired
    public RouterRuleCache(Environment environment) {
        this.environment = environment;
        this.representer.getPropertyUtils().setSkipMissingProperties(true);
        GovernanceEventManager.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doInit(String targetServiceName) {
        if (!this.isServerContainRule(targetServiceName)) {
            return false;
        }
        if (!this.serviceInfoCacheMap.containsKey(targetServiceName)) {
            Object object = this.lock;
            synchronized (object) {
                if (this.serviceInfoCacheMap.containsKey(targetServiceName)) {
                    return true;
                }
                return this.addAllRule(targetServiceName);
            }
        }
        return true;
    }

    @Subscribe
    public void onConfigurationChangedEvent(GovernanceConfigurationChangedEvent event) {
        for (String key : event.getChangedConfigurations()) {
            if (key.startsWith(ROUTE_RULE_PREFIX)) {
                this.serviceInfoCacheMap.remove(key.substring(ROUTE_RULE_PREFIX.length()));
            }
            if (!key.equals(GLOBAL_ROUTE_RULE_KEY)) continue;
            this.serviceInfoCacheMap.clear();
        }
    }

    private boolean addAllRule(String targetServiceName) {
        List<PolicyRuleItem> policyRuleItemList;
        String ruleStr = this.environment.getProperty(String.format(ROUTE_RULE, targetServiceName), "");
        if (StringUtils.isEmpty((CharSequence)ruleStr)) {
            ruleStr = this.environment.getProperty(GLOBAL_ROUTE_RULE_KEY, "");
        }
        if (StringUtils.isEmpty((CharSequence)ruleStr)) {
            return false;
        }
        try {
            Yaml entityParser = new Yaml((BaseConstructor)new Constructor(new TypeDescription(PolicyRuleItem[].class, PolicyRuleItem[].class), new LoaderOptions()), this.representer);
            policyRuleItemList = Arrays.asList((PolicyRuleItem[])entityParser.loadAs(ruleStr, PolicyRuleItem[].class));
        }
        catch (Exception e) {
            LOGGER.warn("Route management serialization for service {} failed: {}", (Object)targetServiceName, (Object)e.getMessage());
            return false;
        }
        if (CollectionUtils.isEmpty(policyRuleItemList)) {
            LOGGER.warn("Route management serialization for service {} is empty", (Object)targetServiceName);
            return false;
        }
        ServiceInfoCache serviceInfoCache = new ServiceInfoCache(policyRuleItemList);
        this.serviceInfoCacheMap.put(targetServiceName, serviceInfoCache);
        LOGGER.info("Route management serialization service {} rules success, content: {}", (Object)targetServiceName, serviceInfoCache.getAllrule());
        return true;
    }

    private boolean isServerContainRule(String targetServiceName) {
        return !StringUtils.isEmpty((CharSequence)this.environment.getProperty(String.format(ROUTE_RULE, targetServiceName), "")) || !StringUtils.isEmpty((CharSequence)this.environment.getProperty(GLOBAL_ROUTE_RULE_KEY, ""));
    }

    public ConcurrentHashMap<String, ServiceInfoCache> getServiceInfoCacheMap() {
        return this.serviceInfoCacheMap;
    }

    @VisibleForTesting
    void refresh() {
        this.serviceInfoCacheMap.clear();
    }

    public void refresh(String targetServiceName) {
        this.serviceInfoCacheMap.remove(targetServiceName);
    }
}

