/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.service.center.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.http.client.common.AbstractAddressManager;
import org.apache.servicecomb.http.client.common.HttpRequest;
import org.apache.servicecomb.http.client.common.HttpResponse;
import org.apache.servicecomb.http.client.common.HttpTransport;
import org.apache.servicecomb.http.client.utils.ServiceCombServiceAvailableUtils;
import org.apache.servicecomb.service.center.client.ServiceCenterAddressManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCenterRawClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCenterRawClient.class);
    private static final String HEADER_TENANT_NAME = "x-domain-name";
    private static final String ADDRESS_CHECK_PATH = "/v4/default/registry/health/readiness";
    private final String tenantName;
    private final HttpTransport httpTransport;
    private final ServiceCenterAddressManager addressManager;

    private ServiceCenterRawClient(String tenantName, HttpTransport httpTransport, ServiceCenterAddressManager addressManager) {
        this.httpTransport = httpTransport;
        this.tenantName = tenantName;
        this.addressManager = addressManager;
    }

    public HttpResponse getHttpRequest(String url, Map<String, String> headers, String content) throws IOException {
        return this.doHttpRequest(url, false, headers, content, "GET");
    }

    public HttpResponse postHttpRequestAbsoluteUrl(String url, Map<String, String> headers, String content) throws IOException {
        return this.doHttpRequest(url, true, headers, content, "POST");
    }

    public HttpResponse postHttpRequest(String url, Map<String, String> headers, String content) throws IOException {
        return this.doHttpRequest(url, false, headers, content, "POST");
    }

    public HttpResponse putHttpRequest(String url, Map<String, String> headers, String content) throws IOException {
        return this.doHttpRequest(url, false, headers, content, "PUT");
    }

    public HttpResponse deleteHttpRequest(String url, Map<String, String> headers, String content) throws IOException {
        return this.doHttpRequest(url, false, headers, content, "DELETE");
    }

    private HttpResponse doHttpRequest(String url, boolean absoluteUrl, Map<String, String> headers, String content, String method) throws IOException {
        String address = this.addressManager.address();
        String formatUrl = this.addressManager.formatUrl(url, absoluteUrl, address);
        HttpRequest httpRequest = this.buildHttpRequest(formatUrl, headers, content, method);
        try {
            HttpResponse httpResponse = this.httpTransport.doRequest(httpRequest);
            this.addressManager.recordSuccessState(address);
            return httpResponse;
        }
        catch (IOException e) {
            this.addressManager.recordFailState(address);
            String retryAddress = this.addressManager.address();
            formatUrl = this.addressManager.formatUrl(url, absoluteUrl, retryAddress);
            LOGGER.warn("send request to {} failed and retry to {} once. ", new Object[]{address, retryAddress, e});
            httpRequest = new HttpRequest(formatUrl, headers, content, method);
            try {
                return this.httpTransport.doRequest(httpRequest);
            }
            catch (IOException ioException) {
                this.addressManager.recordFailState(retryAddress);
                LOGGER.warn("retry to {} failed again. ", (Object)retryAddress, (Object)e);
                throw ioException;
            }
        }
    }

    public void checkAddressAvailable(String address) {
        ServiceCombServiceAvailableUtils.checkAddressAvailable((AbstractAddressManager)this.addressManager, (String)address, (HttpTransport)this.httpTransport, (String)ADDRESS_CHECK_PATH);
    }

    private HttpRequest buildHttpRequest(String url, Map<String, String> headers, String content, String method) {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put(HEADER_TENANT_NAME, this.tenantName);
        return new HttpRequest(url, headers, content, method);
    }

    public static class Builder {
        private String tenantName;
        private HttpTransport httpTransport;
        private ServiceCenterAddressManager addressManager;

        public Builder setTenantName(String tenantName) {
            this.tenantName = tenantName;
            return this;
        }

        public Builder setHttpTransport(HttpTransport httpTransport) {
            this.httpTransport = httpTransport;
            return this;
        }

        public Builder setAddressManager(ServiceCenterAddressManager addressManager) {
            this.addressManager = addressManager;
            return this;
        }

        public ServiceCenterRawClient build() {
            return new ServiceCenterRawClient(this.tenantName, this.httpTransport, this.addressManager);
        }
    }
}

